#include "mamewrap.h"
#include "bochs.h"
#if BX_EMULATION_TOWNS
#define LOG_THIS bx_fmsound.

void logerror(const char *text,...)
{
  va_list ap;
  char buf[1024];

  va_start(ap, text);
#if HAVE_VSNPRINTF
  vsnprintf(buf, 1024, text, ap);
#else
  vsprintf(buf, text, ap);
#endif
  buf[1023]=0;
  va_end(ap);

  BX_INFO(("fmsound: %s",buf));
}

unsigned cpu_get_pc(void)
{
  // not correct in SMP
  return(BX_CPU(0)->eip+BX_CPU(0)->sregs[BX_SREG_CS].cache.u.segment.base);
}

int osd_fread(void *file,void *buffer,int length)
{
  return(0);
}

int osd_fwrite(void *file,const void *buffer,int length)
{
  return(0);
}

int osd_start_audio_stream(int stereo)
{
  return(0);
}

int osd_update_audio_stream(INT16 *buffer)
{
  return(40000/60);
}

void osd_stop_audio_stream(void)
{
}

void freesamples(struct GameSamples *samples)
{
}
#endif
